<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Social extends Model 
{

    protected $table = 'socials';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'url', 'description');
    protected $visible = array('id_user', 'name', 'url', 'description', 'timestamps');

    public function user()
    {
        return $this->belongsTo('User');
    }

}